Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[caves.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[mission4.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 20.0,
		StartBPMultiplier 	= 1.5,
	},
	Rules = 
	{
		AutoCapture 	= false,		--Destroying hives automatically counts as a capture
		NoPushback		= false,		--Can the player's points be captured?
		NoTowerRespawn  = false,        --Can the hive towers respawn?
		WeakenHiveOnCap = true,         --Do captures halve defensive strength?
		DisableLockdown = false,        --Turn off emergency help is player is behind
		NoAdvance       = false,        --Do not allow player to capture points
		HiveCtrAttack   = true,         --Send alien spawn to undefended alien hives
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 0,
		Default = [[disabled]],
		Active =
		{
		    [[ZU_SANDKING_GUARDIANS]]
		},
		Queue =
		{
			[[ZU_NONE]],
			[[ZU_NONE]],
			[[ZU_HARDPOINT_GUARDS]],	
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[inactive]],
		--FreeUpgradesDefault = [[active]],
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	OnDebugCall = function (mousePos)

	end
}

convoyList = {}

function CreateConvoy(p_marineCount, p_bunkerIndex)

	if convoyList[p_bunkerIndex] == nil then
		convoyList[p_bunkerIndex] = {}
	end


    local baseAngle = GetRandomRange(0.0, math.pi*2)
    local nSpawn = p_marineCount
    for i=1,nSpawn do
        local deltaV = vect2f.MakePolar(GetRandomRangeInt(3.0, 4.0), i/nSpawn*math.pi*2)
        local marineEnt = nil
        
        marineEnt = CreateConvoyMarine(deltaV, p_bunkerIndex)
        
        table.insert(convoyList[p_bunkerIndex], EHandle(marineEnt))
    end

    --return resultList	

end

convoyPath = {}
convoyPath[1] = {"bunker1", "waypoint_start"} 
convoyPath[2] = {"bunker2", "waypoint_final"} 
convoyPath[3] = {"bunker3", "waypoint_final"} 
convoyPath[4] = {"bunker4", "waypoint_final"} 
convoyPath[5] = {"bunker5", "waypoint_final"} 
convoyPath[6] = {"generalDropArea", "waypoint_final"} 

function CreateConvoyMarine(p_offset, p_bunkerIndex)

    local startEnt = GameWorld:GetEntityById(convoyPath[p_bunkerIndex][1]);

    if startEnt == nil then
        return
    end

    local marine = GameWorld:CreateEntity("AIMarine", "", startEnt:GetPos() + p_offset)
    marine:SetPoisonResistance(10000)
    --marine:SetSpeedMultiple(2.0)
    
    local nWaypoints = #convoyPath[p_bunkerIndex]
    for i=1,nWaypoints do
        local waypoint = GameWorld:GetEntityById(convoyPath[p_bunkerIndex][i]);

        if waypoint then
            marine:SendCommand(ICommandable.CT_ATTACKMOVE, waypoint:GetPos() + p_offset, nil, true)
        end
    end

    return marine

end

function filter_inplace(t, predicate)
    local j = 1
     
    for i = 1,#t do
        local v = t[i]
        if predicate(v) then
            t[j] = v
            j = j + 1
        end
    end
     
    while t[j] ~= nil do
        t[j] = nil
        j = j + 1
    end
     
    return t
end

convoySize = 2
convoyTimerMax = 10000
convoyTimers = {0, 2000, 5000, 7000, 10000}

function ConvoysUpdate(p_time)

	local numConvoys = #convoyTimers
	for i=1, numConvoys do
		if convoyList[i] == nil then
			convoyList[i] = {}
		end
	
		filter_inplace(convoyList[i], function(p_handle) return p_handle:GetPtr() ~= nil end)
		
		if #convoyList[i] < convoySize then
			convoyTimers[i] = convoyTimers[i] - p_time
			
			if convoyTimers[i] < 0 then
				convoyTimers[i] = convoyTimerMax
				CreateConvoy(convoySize - #convoyList[i], i)
			end	
		end
	end

end

ScriptMgr:SetUpdateCallback(ConvoysUpdate)

------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		

        for i=1, #convoyPath do
            local bunker = GameWorld:GetEntityById(convoyPath[i][1])
            
            if bunker then
                bunker:SetIsInvisible(true)
            end
        end
        --GameWorld:RegisterRaidTarget(lab)
		
		LevelUtils.ShowTimedDialogue("This attack has gone off the rails.\n\nWe've gotta bail the army out - they'll help us in return.", "Sarge")

        LossCondition:Enable()
        KillBossObjective:Enable()

		self:Disable()
	end)
LevelInit:Enable()

-- Update the big HP display
function UpdateBossHP()

    local boss = GameWorld:GetEntityById("bossHive")
    local bossHpPct = 0
    if boss then
        bossHpPct = boss:GetHPFraction() * 100  
    end

    GameWorld:SetEventIndicator(string.format("%d%% Lifeform Integrity", bossHpPct))

end

------------------------------------------------------------------------------- Kill the Boss hive objective
KillBossObjective = LevelUtils.MakeGoal(
	function (self)
        --LevelUtils.ShowTimedDialogue("The big hive is vulnerable, commander\n\nConcentrate fire on it to overcome the regeneration", "Scout")     
        
        local boss = GameWorld:GetEntityById("bossHive")
        if boss then
            boss:SetDamageResistance(2.0) 
			
			local bossHandle = boss:GetHandle()
			LevelUtils.CreateEntityHPMonitor(bossHandle, {0.75, 0.55, 0.25},
				function (p_hpFract)
					local text_hdl = nil
					if p_hpFract == 0.75 then
						text_hdl = GameWorld:ShowText("That's it, keep up the attack!\n\nFocus fire on the organism!", "General")	
					elseif p_hpFract == 0.55 then
						text_hdl = GameWorld:ShowText("Yes, look at it bleeding\n\nKeep FIRING!", "General")	
					elseif p_hpFract == 0.25 then
						text_hdl = GameWorld:ShowText("DIE!!!\n\nI've killed you once and I'll do it again and again.", "General")
					end
					
					if text_hdl then
						ScriptMgr:DoDelayedCall(7000,
							function ()
								text_hdl:ClearText()
							end) 
					end
				end)
			
        end
        
        
	    GameWorld:AddObjective("bossObj", "Destroy the giant hive")
	                            
	    ScriptMgr:DoDelayedCall(200, 	function ()
	                                        UpdateBossHP()
	                                        return true
                                        end)
    end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
        if p_entId ~= "bossHive" then
            return
        end

        GameWorld:ChangeObjectiveStatus("bossObj", [[complete]])

        local text_hdl = GameWorld:ShowText("Stay down ugly!\n\nI'm tired of wastin bullets on your ugly carcass.", "Sarge")
		ScriptMgr:DoDelayedCall(5000,
            function()
                GameWorld:GameOver(true)
                GameWorld:ClearText()
            end)	
	end,
	
	function (self)
	end)
		
------------------------------------------------------------------------------- Lost all points
LossCondition = LevelUtils.MakeGoal(
	function (self)	
	end,
	
	{[[NT_ALL_POINTS_LOST]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[failed]])
	
		GameWorld:ClearText()
		GameWorld:GameOver(false)
	
		CaptureAllGoal:Disable()
	
		self:Disable()
	end)
LossCondition:Enable()

------------------------------------------------------------------------------- Dialogue Triggers
DialogueScript = LevelUtils.MakeGoal(
	function (self)
		self.capture_counter = 0
	end,
	
	{[[NT_CAPTURE_RECORD]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
        self.capture_counter = self.capture_counter + 1
        
        local texthdl = nil
        if self.capture_counter == 1 then
            texthdl = GameWorld:ShowText("This in a new mutation strain.\n\nIt's almost as if it is trying to imitate us.", "Scout")
        elseif self.capture_counter == 3 then
            texthdl = GameWorld:ShowText("Watch out - they're mutating again.\n\nSome sort of nest?!", "Scout")
        elseif self.capture_counter == 6 then
            texthdl = GameWorld:ShowText("What the hell are you waiting for Drake?\n\nI'm coming down there myself to finish the job.", "General")
			GeneralDrop:Enable()
		end
        
        if texthdl then
            ScriptMgr:DoDelayedCall(15000, function () texthdl:ClearText(); end)
        end
      
	end)
DialogueScript:Enable()

------------------------------------------------------------------------------- General Chopper Delivery
GeneralDrop = LevelUtils.MakeGoal(
	function (self)	
		local dropArea = GameWorld:GetEntityById("generalDropArea");
		if dropArea then
			local chopper = GameWorld:SpawnChopper(vect2f(0.3, 1.0), dropArea:GetPos())
			chopper:SetMission(ChopperOrder.CO_DELIVERY, dropArea:GetPos(), "General")
		end
		
	end,
	
	{[[NT_CHOPPER_DELIVERY]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		if p_other ~= "General" then
			return
		end
		
		local general = CreateConvoyMarine(vect2f(0.0,0.0), 6)
		
		general:SetWeaponType(WeaponType.WT_MINIGUN)
		general:SetGodMode(true)
		
		self:Disable()
	end)